/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.WallType;

@Singleton
public class WallTypeDictionary {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<Long, WallType> wallTypeIdMap = new ConcurrentHashMap<Long, WallType>();
    private Map<String, WallType> nameMap = new ConcurrentHashMap<String, WallType>();

    @Inject
    public WallTypeDictionary() throws IOException {
        this(Gdx.files.internal("assets/definitions/walls.json"));
    }

    public WallTypeDictionary(FileHandle wallDefinitionsJsonFile) throws IOException {
        List wallTypes = (List)this.objectMapper.readValue(wallDefinitionsJsonFile.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, WallType.class));
        for (WallType wallType : wallTypes) {
            if (this.wallTypeIdMap.containsKey(wallType.getWallTypeId())) {
                throw new IOException("Duplicate ID for wall: " + wallType);
            }
            this.wallTypeIdMap.put(wallType.getWallTypeId(), wallType);
            this.nameMap.put(wallType.getWallTypeName(), wallType);
        }
    }

    public WallType getByWallTypeId(long id) {
        return this.wallTypeIdMap.get(id);
    }

    public WallType getByWallTypeName(String name) {
        return this.nameMap.get(name);
    }

    public Iterable<WallType> getAllDefinitions() {
        return this.wallTypeIdMap.values();
    }
}

